#define PADS_TERM
#include <pads.h>
#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <Xol/OpenLook.h>
#include <Xol/TextEdit.h>

long assertf();
#define ASSERT
#define assert(e) ( assertf( (long) (e) ) )
#define salloc(s) ((struct s*) Alloc(sizeof(struct s)) )

#define MAXPOPUPS	10

typedef struct PadObj {
	long		object;
	Index		carte;
	Attrib		attributes;
	short		oid;
} PadObj;

typedef struct PadLine {
	PadObj		po;
	char		*text;
	long		key;
	long		windowline;
 struct	PadLine		*down;
 struct	PadLine		*up;
} PadLine;

typedef struct Pad {
	PadObj		po;
 struct	Pad		*front;
 struct	Pad		*back;
	char		*name;
	PadLine		sentinel;
	short		ticks;
	short		tabs;
	Index		helpcarte;
/* OpenLook */
	int		haswindow;
	Widget		pane;
	Widget		form;
	Widget		control;
	Widget		scrollwin;
	Widget		textw;
	TextBuffer	*textb;
	Widget		namemenuentry;
	int		nomenus;
	Widget		menus[MAXPOPUPS];
	int		nopopups;
	int		popstate;
	Widget		popups[MAXPOPUPS];
} Pad;

#define ISPAD(p) ((p) != &Sentinel)
#define ISLINE(l,p) ((l) != &(p)->sentinel)

typedef struct Selection {
	Pad	*pad;
	PadLine	*line;
	int	lineno;
} Selection;

char *itoa();
char *padnametoresource();
char *Alloc();
char *GCAlloc();
char *IndexToStr();
Carte *IndexToCarte();
PadLine *LineiToPadLine();

/* Openlook stuff */
extern Widget	basepane;
extern Widget	keytextw;
extern Widget	LineShell;
extern Pad	Sentinel;
extern int	keyinputclosed;
